<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Sign in – MAFIA MAILER</title>

<style>
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

/* ========= VARIABLES ========= */
:root {
    --blue: #2563eb;
    --blue-dark: #1d4ed8;
    --gray: #6b7280;
    --border: #e5e7eb;
    --bg-soft: #f8fafc;
}

/* ========= BODY ========= */
body {
    font-family: "Inter", "Segoe UI", system-ui, -apple-system, BlinkMacSystemFont, sans-serif;
    background: radial-gradient(circle at top, #eef2ff, #ffffff 65%);
    min-height: 100vh;
    display: flex;
    align-items: center;
    justify-content: center;
}

/* ========= CARD ========= */
.login-container {
    width: 100%;
    max-width: 430px;
    background: #ffffff;
    padding: 50px 44px;
    border-radius: 16px;
    box-shadow:
        0 30px 60px rgba(0,0,0,0.08),
        0 1px 0 rgba(255,255,255,0.7) inset;
    animation: fadeUp .9s cubic-bezier(.22,1,.36,1);
}

/* ========= LOGO ========= */
.logo {
    text-align: center;
    margin-bottom: 26px;
    animation: float 6s ease-in-out infinite;
}

.logo img {
    max-width: 165px;
    height: auto;
}

/* ========= HEADER ========= */
.login-header h1 {
    text-align: center;
    font-size: 26px;
    font-weight: 600;
    color: #111827;
    margin-bottom: 6px;
}

.login-header p {
    text-align: center;
    font-size: 14px;
    color: var(--gray);
    margin-bottom: 32px;
}

/* ========= ALERTS ========= */
.alert {
    padding: 14px;
    border-radius: 8px;
    font-size: 13px;
    margin-bottom: 22px;
    animation: shake .4s;
}

.alert-error {
    background: #fee2e2;
    color: #991b1b;
}

.alert-success {
    background: #dcfce7;
    color: #166534;
}

/* ========= FORM ========= */
.form-group {
    margin-bottom: 28px;
}

.form-group label {
    display: block;
    font-size: 13px;
    color: var(--gray);
    margin-bottom: 6px;
    transition: color .2s;
}

.form-group input {
    width: 100%;
    border: none;
    border-bottom: 2px solid var(--border);
    padding: 10px 4px;
    font-size: 15px;
    outline: none;
    transition: border-color .3s, box-shadow .3s;
}

.form-group input:focus {
    border-bottom-color: var(--blue);
    box-shadow: 0 8px 22px rgba(37,99,235,.15);
}

/* ========= BUTTON ========= */
.btn-login {
    width: 100%;
    margin-top: 6px;
    padding: 14px;
    border: none;
    border-radius: 12px;
    background: linear-gradient(135deg, #9ca3af, #9ca3af);
    color: #ffffff;
    font-size: 15px;
    font-weight: 500;
    cursor: not-allowed;
    transition: all .4s cubic-bezier(.22,1,.36,1);
}

.btn-login.enabled {
    background: linear-gradient(135deg, var(--blue), var(--blue-dark));
    cursor: pointer;
}

.btn-login.enabled:hover {
    transform: translateY(-2px);
    box-shadow: 0 18px 36px rgba(37,99,235,.35);
}

/* ========= FOOTER ========= */
.login-footer {
    margin-top: 34px;
    text-align: center;
    font-size: 12px;
    color: var(--gray);
}

/* ========= ANIMATIONS ========= */
@keyframes fadeUp {
    from {
        opacity: 0;
        transform: translateY(30px) scale(.96);
    }
    to {
        opacity: 1;
        transform: none;
    }
}

@keyframes float {
    0%,100% { transform: translateY(0); }
    50% { transform: translateY(-6px); }
}

@keyframes shake {
    0% { transform: translateX(0); }
    25% { transform: translateX(-4px); }
    50% { transform: translateX(4px); }
    75% { transform: translateX(-2px); }
    100% { transform: translateX(0); }
}
</style>
</head>

<body>

<div class="login-container">

    <!-- LOGO -->
    <div class="logo">
        <img src="sendgrid-logo.svg" alt="Logo">
    </div>

    <!-- HEADER -->
    <div class="login-header">
        <h1>Sign in</h1>
        <p>MAFIA MAILER</p>
    </div>

    <!-- ALERTS -->
    <?php if (isset($_GET['error'])): ?>
        <div class="alert alert-error">
            Invalid username or password.
        </div>
    <?php endif; ?>

    <?php if (isset($_GET['logged_out'])): ?>
        <div class="alert alert-success">
            You have been logged out successfully.
        </div>
    <?php endif; ?>

    <!-- FORM -->
    <form method="POST" action="?action=do_login">

        <div class="form-group">
            <label for="username">Username (this may be your email address)</label>
            <input type="text" id="username" name="username" required autofocus>
        </div>

        <div class="form-group">
            <label for="password">Password</label>
            <input type="password" id="password" name="password" required>
        </div>

        <button type="submit" class="btn-login" id="loginBtn" disabled>
            Continue
        </button>

    </form>

    <div class="login-footer">
        © <?php echo date('Y'); ?> MAFIA MAILER
    </div>

</div>

<!-- ========= JS ========= -->
<script>
const username = document.getElementById('username');
const password = document.getElementById('password');
const btn = document.getElementById('loginBtn');

function toggleButton() {
    const ready = username.value.trim() && password.value.trim();
    btn.disabled = !ready;
    btn.classList.toggle('enabled', ready);
}

username.addEventListener('input', toggleButton);
password.addEventListener('input', toggleButton);
</script>

</body>
</html>
